package gov.va.med.mhv.admin.repository;

import java.util.List;

import gov.va.med.mhv.admin.model.CalendarCategory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CalendarCategoryRepository extends JpaRepository<CalendarCategory, Long> {

	@Query("select calCat from CalendarCategory calCat " + "where (calCat.deleted is null) or (calCat.deleted = 0) "
			+ "order by UPPER(calCat.categoryName) asc")
	public List<CalendarCategory> getAllActiveCategories();
}
